package mplab;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;


public class MplabMcpParser {
	//constantes de los estados del parser
	public static final int INIT = 0;
	public static final int HEADER = 1;
	public static final int PATH_INFO = 2;
	public static final int CAT_FILTERS = 3;
	public static final int OTHER_FILES = 4;
	public static final int FILE_INFO = 5;
	public static final int SUITE_INFO = 6;
	public static final int	TOOL_SETTINGS = 7;
	public static final int INSTRUMENTED_TRACE =8;

	//estado actual del parser
	private int estado;
	private String mcpFilename;
	
	//datos parseados
	private String binDir;
	private String tmpDir;
	private String incDir;
	private String libDir;
	private String lkrDir;
	
	private Vector<String> cFiles;
	private Vector<String> hFiles;
	private String lkrFile;
	
	private String lkrFlags;
	private String ccFlags;
	
	//otros datos
	private String projectFolder;
	private String projectName;
	//getters and setters

	public String getMcpFilename() {
		return mcpFilename;
	}
	
	public void setMcpFilename(String mcpFilename) {
		this.mcpFilename = mcpFilename;
	}
	
	public String getBinDir() {
		return binDir;
	}
	
	public String getCcFlags() {
		return ccFlags;
	}
	
	public Vector<String> getCFiles() {
		return cFiles;
	}
	
	public int getEstado() {
		return estado;
	}
	
	public Vector<String> getHFiles() {
		return hFiles;
	}
	
	public String getIncDir() {
		return incDir;
	}
	
	public String getLibDir() {
		return libDir;
	}

	public String getLkrDir() {
		return lkrDir;
	}
	
	public String getLkrFile() {
		return lkrFile;
	}
	
	public String getLkrFlags() {
		return lkrFlags;
	}
	
	public String getProjectFolder() {
		return projectFolder;
	}
	
	public String getTmpDir() {
		return tmpDir;
	}
	
	
	public String getProjectName() {
		return projectName;
	}

	public void parse(String mcpFilename){
		//guardo el filname del mcp
		this.mcpFilename=mcpFilename;
		
		//guardo el project name
		int lastroot = mcpFilename.lastIndexOf('\\');
		projectName = mcpFilename.substring(lastroot+1,mcpFilename.length()-4);
		
		//inicio el estado del parser
		estado = INIT;
		
		//creo las colecciones
		cFiles = new Vector<String>();
		hFiles = new Vector<String>();
		
		//cargo el archivo
		try {
			/*
			 * Sets up a file reader to read the file passed on the
			 * command line one character at a time
			 */
			FileReader input = new FileReader(mcpFilename);
			
			/*
			 * Filter FileReader through a Buffered read to read a line
			 * at a time
			 */
			BufferedReader bufRead = new BufferedReader(input);
			String line;    // String that holds current file line
			
			while ((line = bufRead.readLine()) != null){
				//me fijo si cambio de estado en el parser o proceso una linea normal
				if (line.startsWith("[")) {
					//debo cambiar de estado pues es una "seccion"
					if (line.startsWith("[HEADER]")) estado = HEADER;
					if (line.startsWith("[PATH_INFO]")) estado = PATH_INFO;
					if (line.startsWith("[CAT_FILTERS]")) estado = CAT_FILTERS;
					if (line.startsWith("[OTHER_FILES]")) estado = OTHER_FILES;
					if (line.startsWith("[FILE_INFO]")) estado = FILE_INFO;
					if (line.startsWith("[SUITE_INFO]")) estado = SUITE_INFO;
					if (line.startsWith("[TOOL_SETTINGS]")) estado = TOOL_SETTINGS;
					if (line.startsWith("[INSTRUMENTED_TRACE]")) estado =INSTRUMENTED_TRACE;
				}
				else {
					//proceso la linea segun el estado que estoy
					int equalPos = line.indexOf('=');
					
					switch (estado){
						case HEADER:
								
							break;
						case PATH_INFO:
							if (line.startsWith("dir_bin")) binDir = line.substring(equalPos+1, line.length());
							if (line.startsWith("dir_tmp")) tmpDir = line.substring(equalPos+1, line.length());
							if (line.startsWith("dir_inc")) incDir = line.substring(equalPos+1, line.length());
							if (line.startsWith("dir_lib")) libDir = line.substring(equalPos+1, line.length());
							if (line.startsWith("dir_lkr")) lkrDir = line.substring(equalPos+1, line.length());
							break;
							
						case CAT_FILTERS:
														
							break;
						case OTHER_FILES:
							
							break;
						case FILE_INFO:
							if (line.endsWith(".c") || line.endsWith(".C")) cFiles.add(line.substring(equalPos+1, line.length()));
							if (line.endsWith(".h") || line.endsWith(".h")) hFiles.add(line.substring(equalPos+1, line.length()));	
							if (line.endsWith(".lkr") || line.endsWith(".LKR")) lkrFile= line.substring(equalPos+1, line.length());
							break;
						case SUITE_INFO:
							
							break;
						case TOOL_SETTINGS:
							if (line.startsWith("TS{BFD27FBA-4A02-4C0E-A5E5-B812F3E7707C}")) lkrFlags = line.substring(equalPos+1, line.length()); 							
							if (line.startsWith("TS{C2AF05E7-1416-4625-923D-E114DB6E2B96}")) ccFlags = line.substring(equalPos+1, line.length());
							break;
						
						case INSTRUMENTED_TRACE:
							
							break;
							
						default:
							
							break;
					
					}
					
					
				}
			
			
				}
			bufRead.close();
			
		}catch (IOException e){
			// If another exception is generated, print a stack
			// trace
			e.printStackTrace();
			//TODO tirar una excepcion para arriba
		}
	}
}
